---
layout: default
title: bicep resource scans
nav_order: 1
---

# bicep resource scans (auto generated)

|     | Id            | Type      | Entity                                                                       | Policy                                                                                                            | IaC   | Resource Link                                                                                                                                                                                                |
|-----|---------------|-----------|------------------------------------------------------------------------------|-------------------------------------------------------------------------------------------------------------------|-------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
|   0 | CKV_AZURE_1   | resource  | Microsoft.Compute/virtualMachines                                            | Ensure Azure Instance does not use basic authentication(Use SSH Key Instead)                                      | Bicep | [AzureInstancePassword.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AzureInstancePassword.py)                                                                           |
|   1 | CKV_AZURE_2   | resource  | Microsoft.Compute/disks                                                      | Ensure Azure managed disk have encryption enabled                                                                 | Bicep | [AzureManagedDiscEncryption.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AzureManagedDiscEncryption.py)                                                                 |
|   2 | CKV_AZURE_3   | resource  | Microsoft.Storage/storageAccounts                                            | Ensure that 'supportsHttpsTrafficOnly' is set to 'true'                                                           | Bicep | [StorageAccountsTransportEncryption.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/bicep/checks/resource/azure/StorageAccountsTransportEncryption.py)                                         |
|   3 | CKV_AZURE_4   | resource  | Microsoft.ContainerService/managedClusters                                   | Ensure AKS logging to Azure Monitoring is Configured                                                              | Bicep | [AKSLoggingEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AKSLoggingEnabled.py)                                                                                   |
|   4 | CKV_AZURE_5   | resource  | Microsoft.ContainerService/managedClusters                                   | Ensure RBAC is enabled on AKS clusters                                                                            | Bicep | [AKSRbacEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AKSRbacEnabled.py)                                                                                         |
|   5 | CKV_AZURE_6   | resource  | Microsoft.ContainerService/managedClusters                                   | Ensure AKS has an API Server Authorized IP Ranges enabled                                                         | Bicep | [AKSApiServerAuthorizedIpRanges.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AKSApiServerAuthorizedIpRanges.py)                                                         |
|   6 | CKV_AZURE_7   | resource  | Microsoft.ContainerService/managedClusters                                   | Ensure AKS cluster has Network Policy configured                                                                  | Bicep | [AKSNetworkPolicy.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AKSNetworkPolicy.py)                                                                                     |
|   7 | CKV_AZURE_8   | resource  | Microsoft.ContainerService/managedClusters                                   | Ensure Kubernetes Dashboard is disabled                                                                           | Bicep | [AKSDashboardDisabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AKSDashboardDisabled.py)                                                                             |
|   8 | CKV_AZURE_9   | resource  | Microsoft.Network/networkSecurityGroups                                      | Ensure that RDP access is restricted from the internet                                                            | Bicep | [NSGRuleRDPAccessRestricted.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/NSGRuleRDPAccessRestricted.py)                                                                 |
|   9 | CKV_AZURE_9   | resource  | Microsoft.Network/networkSecurityGroups/securityRules                        | Ensure that RDP access is restricted from the internet                                                            | Bicep | [NSGRuleRDPAccessRestricted.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/NSGRuleRDPAccessRestricted.py)                                                                 |
|  10 | CKV_AZURE_10  | resource  | Microsoft.Network/networkSecurityGroups                                      | Ensure that SSH access is restricted from the internet                                                            | Bicep | [NSGRuleSSHAccessRestricted.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/NSGRuleSSHAccessRestricted.py)                                                                 |
|  11 | CKV_AZURE_10  | resource  | Microsoft.Network/networkSecurityGroups/securityRules                        | Ensure that SSH access is restricted from the internet                                                            | Bicep | [NSGRuleSSHAccessRestricted.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/NSGRuleSSHAccessRestricted.py)                                                                 |
|  12 | CKV_AZURE_11  | resource  | Microsoft.Sql/servers                                                        | Ensure no SQL Databases allow ingress from 0.0.0.0/0 (ANY IP)                                                     | Bicep | [SQLServerNoPublicAccess.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/SQLServerNoPublicAccess.py)                                                                       |
|  13 | CKV_AZURE_12  | resource  | Microsoft.Network/networkWatchers/FlowLogs                                   | Ensure that Network Security Group Flow Log retention period is 'greater than 90 days'                            | Bicep | [NetworkWatcherFlowLogPeriod.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/NetworkWatcherFlowLogPeriod.py)                                                               |
|  14 | CKV_AZURE_12  | resource  | Microsoft.Network/networkWatchers/FlowLogs/                                  | Ensure that Network Security Group Flow Log retention period is 'greater than 90 days'                            | Bicep | [NetworkWatcherFlowLogPeriod.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/NetworkWatcherFlowLogPeriod.py)                                                               |
|  15 | CKV_AZURE_12  | resource  | Microsoft.Network/networkWatchers/flowLogs                                   | Ensure that Network Security Group Flow Log retention period is 'greater than 90 days'                            | Bicep | [NetworkWatcherFlowLogPeriod.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/NetworkWatcherFlowLogPeriod.py)                                                               |
|  16 | CKV_AZURE_12  | resource  | Microsoft.Network/networkWatchers/flowLogs/                                  | Ensure that Network Security Group Flow Log retention period is 'greater than 90 days'                            | Bicep | [NetworkWatcherFlowLogPeriod.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/NetworkWatcherFlowLogPeriod.py)                                                               |
|  17 | CKV_AZURE_13  | resource  | Microsoft.Web/sites/config                                                   | Ensure App Service Authentication is set on Azure App Service                                                     | Bicep | [AppServiceAuthentication.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AppServiceAuthentication.py)                                                                     |
|  18 | CKV_AZURE_13  | resource  | config                                                                       | Ensure App Service Authentication is set on Azure App Service                                                     | Bicep | [AppServiceAuthentication.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AppServiceAuthentication.py)                                                                     |
|  19 | CKV_AZURE_14  | resource  | Microsoft.Web/sites                                                          | Ensure web app redirects all HTTP traffic to HTTPS in Azure App Service                                           | Bicep | [AppServiceHTTPSOnly.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AppServiceHTTPSOnly.py)                                                                               |
|  20 | CKV_AZURE_15  | resource  | Microsoft.Web/sites                                                          | Ensure web app is using the latest version of TLS encryption                                                      | Bicep | [AppServiceMinTLSVersion.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AppServiceMinTLSVersion.py)                                                                       |
|  21 | CKV_AZURE_16  | resource  | Microsoft.Web/sites                                                          | Ensure that Register with Azure Active Directory is enabled on App Service                                        | Bicep | [AppServiceIdentity.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AppServiceIdentity.py)                                                                                 |
|  22 | CKV_AZURE_17  | resource  | Microsoft.Web/sites                                                          | Ensure the web app has 'Client Certificates (Incoming client certificates)' set                                   | Bicep | [AppServiceClientCertificate.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AppServiceClientCertificate.py)                                                               |
|  23 | CKV_AZURE_18  | resource  | Microsoft.Web/sites                                                          | Ensure that 'HTTP Version' is the latest if used to run the web app                                               | Bicep | [AppServiceHttps20Enabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AppServiceHttps20Enabled.py)                                                                     |
|  24 | CKV_AZURE_19  | resource  | Microsoft.Security/pricings                                                  | Ensure that standard pricing tier is selected                                                                     | Bicep | [SecurityCenterStandardPricing.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/SecurityCenterStandardPricing.py)                                                           |
|  25 | CKV_AZURE_20  | resource  | Microsoft.Security/securityContacts                                          | Ensure that security contact 'Phone number' is set                                                                | Bicep | [SecurityCenterContactPhone.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/SecurityCenterContactPhone.py)                                                                 |
|  26 | CKV_AZURE_21  | resource  | Microsoft.Security/securityContacts                                          | Ensure that 'Send email notification for high severity alerts' is set to 'On'                                     | Bicep | [SecurityCenterContactEmailAlert.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/SecurityCenterContactEmailAlert.py)                                                       |
|  27 | CKV_AZURE_22  | resource  | Microsoft.Security/securityContacts                                          | Ensure that 'Send email notification for high severity alerts' is set to 'On'                                     | Bicep | [SecurityCenterContactEmailAlertAdmins.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/SecurityCenterContactEmailAlertAdmins.py)                                           |
|  28 | CKV_AZURE_23  | resource  | Microsoft.Sql/servers                                                        | Ensure that 'Auditing' is set to 'On' for SQL servers                                                             | Bicep | [SQLServerAuditingEnabled.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/bicep/checks/graph_checks/SQLServerAuditingEnabled.yaml)                                                           |
|  29 | CKV_AZURE_23  | resource  | Microsoft.Sql/servers/auditingSettings                                       | Ensure that 'Auditing' is set to 'On' for SQL servers                                                             | Bicep | [SQLServerAuditingEnabled.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/bicep/checks/graph_checks/SQLServerAuditingEnabled.yaml)                                                           |
|  30 | CKV_AZURE_23  | resource  | Microsoft.Sql/servers/databases                                              | Ensure that 'Auditing' is set to 'On' for SQL servers                                                             | Bicep | [SQLServerAuditingEnabled.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/bicep/checks/graph_checks/SQLServerAuditingEnabled.yaml)                                                           |
|  31 | CKV_AZURE_23  | resource  | Microsoft.Sql/servers/databases/auditingSettings                             | Ensure that 'Auditing' is set to 'On' for SQL servers                                                             | Bicep | [SQLServerAuditingEnabled.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/bicep/checks/graph_checks/SQLServerAuditingEnabled.yaml)                                                           |
|  32 | CKV_AZURE_24  | resource  | Microsoft.Sql/servers                                                        | Ensure that 'Auditing' Retention is 'greater than 90 days' for SQL servers                                        | Bicep | [SQLServerAuditingRetention90Days.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/bicep/checks/graph_checks/SQLServerAuditingRetention90Days.yaml)                                           |
|  33 | CKV_AZURE_24  | resource  | Microsoft.Sql/servers/auditingSettings                                       | Ensure that 'Auditing' Retention is 'greater than 90 days' for SQL servers                                        | Bicep | [SQLServerAuditingRetention90Days.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/bicep/checks/graph_checks/SQLServerAuditingRetention90Days.yaml)                                           |
|  34 | CKV_AZURE_25  | resource  | Microsoft.Sql/servers                                                        | Azure SQL Server threat detection alerts are enabled for all threat types                                         | Bicep | [SQLServerThreatDetectionTypes.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/bicep/checks/graph_checks/SQLServerThreatDetectionTypes.yaml)                                                 |
|  35 | CKV_AZURE_25  | resource  | Microsoft.Sql/servers/databases                                              | Azure SQL Server threat detection alerts are enabled for all threat types                                         | Bicep | [SQLServerThreatDetectionTypes.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/bicep/checks/graph_checks/SQLServerThreatDetectionTypes.yaml)                                                 |
|  36 | CKV_AZURE_25  | resource  | Microsoft.Sql/servers/databases/securityAlertPolicies                        | Azure SQL Server threat detection alerts are enabled for all threat types                                         | Bicep | [SQLServerThreatDetectionTypes.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/bicep/checks/graph_checks/SQLServerThreatDetectionTypes.yaml)                                                 |
|  37 | CKV_AZURE_25  | resource  | Microsoft.Sql/servers/securityAlertPolicies                                  | Azure SQL Server threat detection alerts are enabled for all threat types                                         | Bicep | [SQLServerThreatDetectionTypes.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/bicep/checks/graph_checks/SQLServerThreatDetectionTypes.yaml)                                                 |
|  38 | CKV_AZURE_26  | resource  | Microsoft.Sql/servers/databases                                              | Ensure that 'Send Alerts To' is enabled for MSSQL servers                                                         | Bicep | [SQLServerEmailAlertsEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/SQLServerEmailAlertsEnabled.py)                                                               |
|  39 | CKV_AZURE_27  | resource  | Microsoft.Sql/servers/databases                                              | Ensure that 'Email service and co-administrators' is 'Enabled' for MSSQL servers                                  | Bicep | [SQLServerEmailAlertsToAdminsEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/SQLServerEmailAlertsToAdminsEnabled.py)                                               |
|  40 | CKV_AZURE_28  | resource  | Microsoft.DBforMySQL/servers                                                 | Ensure 'Enforce SSL connection' is set to 'ENABLED' for MySQL Database Server                                     | Bicep | [MySQLServerSSLEnforcementEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/MySQLServerSSLEnforcementEnabled.py)                                                     |
|  41 | CKV_AZURE_29  | resource  | Microsoft.DBforPostgreSQL/servers                                            | Ensure 'Enforce SSL connection' is set to 'ENABLED' for PostgreSQL Database Server                                | Bicep | [PostgreSQLServerSSLEnforcementEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/PostgreSQLServerSSLEnforcementEnabled.py)                                           |
|  42 | CKV_AZURE_30  | resource  | Microsoft.DBforPostgreSQL/servers/configurations                             | Ensure server parameter 'log_checkpoints' is set to 'ON' for PostgreSQL Database Server                           | Bicep | [PostgreSQLServerLogCheckpointsEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/PostgreSQLServerLogCheckpointsEnabled.py)                                           |
|  43 | CKV_AZURE_30  | resource  | configurations                                                               | Ensure server parameter 'log_checkpoints' is set to 'ON' for PostgreSQL Database Server                           | Bicep | [PostgreSQLServerLogCheckpointsEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/PostgreSQLServerLogCheckpointsEnabled.py)                                           |
|  44 | CKV_AZURE_31  | resource  | Microsoft.DBforPostgreSQL/servers/configurations                             | Ensure configuration 'log_connections' is set to 'ON' for PostgreSQL Database Server                              | Bicep | [PostgreSQLServerLogConnectionsEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/PostgreSQLServerLogConnectionsEnabled.py)                                           |
|  45 | CKV_AZURE_31  | resource  | configurations                                                               | Ensure configuration 'log_connections' is set to 'ON' for PostgreSQL Database Server                              | Bicep | [PostgreSQLServerLogConnectionsEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/PostgreSQLServerLogConnectionsEnabled.py)                                           |
|  46 | CKV_AZURE_32  | resource  | Microsoft.DBforPostgreSQL/servers/configurations                             | Ensure server parameter 'connection_throttling' is set to 'ON' for PostgreSQL Database Server                     | Bicep | [PostgreSQLServerConnectionThrottlingEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/PostgreSQLServerConnectionThrottlingEnabled.py)                               |
|  47 | CKV_AZURE_32  | resource  | configurations                                                               | Ensure server parameter 'connection_throttling' is set to 'ON' for PostgreSQL Database Server                     | Bicep | [PostgreSQLServerConnectionThrottlingEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/PostgreSQLServerConnectionThrottlingEnabled.py)                               |
|  48 | CKV_AZURE_33  | resource  | Microsoft.Storage/storageAccounts/queueServices/providers/diagnosticsettings | Ensure Storage logging is enabled for Queue service for read, write and delete requests                           | Bicep | [StorageAccountLoggingQueueServiceEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/StorageAccountLoggingQueueServiceEnabled.py)                                     |
|  49 | CKV_AZURE_34  | resource  | Microsoft.Storage/storageAccounts/blobServices/containers                    | Ensure that 'Public access level' is set to Private for blob containers                                           | Bicep | [StorageBlobServiceContainerPrivateAccess.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/StorageBlobServiceContainerPrivateAccess.py)                                     |
|  50 | CKV_AZURE_34  | resource  | blobServices/containers                                                      | Ensure that 'Public access level' is set to Private for blob containers                                           | Bicep | [StorageBlobServiceContainerPrivateAccess.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/StorageBlobServiceContainerPrivateAccess.py)                                     |
|  51 | CKV_AZURE_34  | resource  | containers                                                                   | Ensure that 'Public access level' is set to Private for blob containers                                           | Bicep | [StorageBlobServiceContainerPrivateAccess.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/StorageBlobServiceContainerPrivateAccess.py)                                     |
|  52 | CKV_AZURE_35  | resource  | Microsoft.Storage/storageAccounts                                            | Ensure default network access rule for Storage Accounts is set to deny                                            | Bicep | [StorageAccountDefaultNetworkAccessDeny.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/bicep/checks/resource/azure/StorageAccountDefaultNetworkAccessDeny.py)                                 |
|  53 | CKV_AZURE_36  | resource  | Microsoft.Storage/storageAccounts                                            | Ensure 'Trusted Microsoft Services' is enabled for Storage Account access                                         | Bicep | [StorageAccountAzureServicesAccessEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/bicep/checks/resource/azure/StorageAccountAzureServicesAccessEnabled.py)                             |
|  54 | CKV_AZURE_37  | resource  | Microsoft.Insights/logprofiles                                               | Ensure that Activity Log Retention is set 365 days or greater                                                     | Bicep | [MonitorLogProfileRetentionDays.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/MonitorLogProfileRetentionDays.py)                                                         |
|  55 | CKV_AZURE_38  | resource  | Microsoft.Insights/logprofiles                                               | Ensure audit profile captures all the activities                                                                  | Bicep | [MonitorLogProfileCategories.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/MonitorLogProfileCategories.py)                                                               |
|  56 | CKV_AZURE_39  | resource  | Microsoft.Authorization/roleDefinitions                                      | Ensure that no custom subscription owner roles are created                                                        | Bicep | [CustomRoleDefinitionSubscriptionOwner.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/CustomRoleDefinitionSubscriptionOwner.py)                                           |
|  57 | CKV_AZURE_40  | resource  | Microsoft.KeyVault/vaults/keys                                               | Ensure that the expiration date is set on all keys                                                                | Bicep | [KeyExpirationDate.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/KeyExpirationDate.py)                                                                                   |
|  58 | CKV_AZURE_41  | resource  | Microsoft.KeyVault/vaults/secrets                                            | Ensure that the expiration date is set on all secrets                                                             | Bicep | [SecretExpirationDate.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/SecretExpirationDate.py)                                                                             |
|  59 | CKV_AZURE_42  | resource  | Microsoft.KeyVault/vaults                                                    | Ensure the key vault is recoverable                                                                               | Bicep | [KeyvaultRecoveryEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/KeyvaultRecoveryEnabled.py)                                                                       |
|  60 | CKV_AZURE_43  | resource  | Microsoft.Storage/storageAccounts                                            | Ensure Storage Accounts adhere to the naming rules                                                                | Bicep | [StorageAccountName.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/StorageAccountName.py)                                                                                 |
|  61 | CKV_AZURE_44  | resource  | Microsoft.Storage/storageAccounts                                            | Ensure Storage Account is using the latest version of TLS encryption                                              | Bicep | [StorageAccountMinimumTlsVersion.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/StorageAccountMinimumTlsVersion.py)                                                       |
|  62 | CKV_AZURE_45  | resource  | Microsoft.Compute/virtualMachines                                            | Ensure that no sensitive credentials are exposed in VM custom_data                                                | Bicep | [VMCredsInCustomData.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/VMCredsInCustomData.py)                                                                               |
|  63 | CKV_AZURE_47  | resource  | Microsoft.DBforMariaDB/servers                                               | Ensure 'Enforce SSL connection' is set to 'ENABLED' for MariaDB servers                                           | Bicep | [MariaDBSSLEnforcementEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/MariaDBSSLEnforcementEnabled.py)                                                             |
|  64 | CKV_AZURE_48  | resource  | Microsoft.DBforMariaDB/servers                                               | Ensure 'public network access enabled' is set to 'False' for MariaDB servers                                      | Bicep | [MariaDBPublicAccessDisabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/MariaDBPublicAccessDisabled.py)                                                               |
|  65 | CKV_AZURE_49  | resource  | Microsoft.Compute/virtualMachineScaleSets                                    | Ensure Azure linux scale set does not use basic authentication(Use SSH Key Instead)                               | Bicep | [AzureScaleSetPassword.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AzureScaleSetPassword.py)                                                                           |
|  66 | CKV_AZURE_50  | resource  | Microsoft.Compute/virtualMachines                                            | Ensure Virtual Machine Extensions are not Installed                                                               | Bicep | [AzureInstanceExtensions.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AzureInstanceExtensions.py)                                                                       |
|  67 | CKV_AZURE_52  | resource  | Microsoft.Sql/servers                                                        | Ensure MSSQL is using the latest version of TLS encryption                                                        | Bicep | [MSSQLServerMinTLSVersion.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/MSSQLServerMinTLSVersion.py)                                                                     |
|  68 | CKV_AZURE_53  | resource  | Microsoft.DBforMySQL/flexibleServers                                         | Ensure 'public network access enabled' is set to 'False' for mySQL servers                                        | Bicep | [MySQLPublicAccessDisabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/MySQLPublicAccessDisabled.py)                                                                   |
|  69 | CKV_AZURE_53  | resource  | Microsoft.DBforMySQL/servers                                                 | Ensure 'public network access enabled' is set to 'False' for mySQL servers                                        | Bicep | [MySQLPublicAccessDisabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/MySQLPublicAccessDisabled.py)                                                                   |
|  70 | CKV_AZURE_54  | resource  | Microsoft.DBforMySQL/servers                                                 | Ensure MySQL is using the latest version of TLS encryption                                                        | Bicep | [MySQLServerMinTLSVersion.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/MySQLServerMinTLSVersion.py)                                                                     |
|  71 | CKV_AZURE_56  | resource  | Microsoft.Web/sites/config                                                   | Ensure that function apps enables Authentication                                                                  | Bicep | [FunctionAppsEnableAuthentication.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/FunctionAppsEnableAuthentication.py)                                                     |
|  72 | CKV_AZURE_57  | resource  | Microsoft.Web/sites                                                          | Ensure that CORS disallows every resource to access app services                                                  | Bicep | [AppServiceDisallowCORS.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AppServiceDisallowCORS.py)                                                                         |
|  73 | CKV_AZURE_58  | resource  | Microsoft.Synapse/workspaces                                                 | Ensure that Azure Synapse workspaces enables managed virtual networks                                             | Bicep | [SynapseWorkspaceEnablesManagedVirtualNetworks.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/SynapseWorkspaceEnablesManagedVirtualNetworks.py)                           |
|  74 | CKV_AZURE_59  | resource  | Microsoft.Storage/storageAccounts                                            | Ensure that Storage accounts disallow public access                                                               | Bicep | [StorageAccountDisablePublicAccess.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/StorageAccountDisablePublicAccess.py)                                                   |
|  75 | CKV_AZURE_62  | resource  | Microsoft.Web/sites                                                          | Ensure function apps are not accessible from all regions                                                          | Bicep | [FunctionAppDisallowCORS.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/FunctionAppDisallowCORS.py)                                                                       |
|  76 | CKV_AZURE_63  | resource  | Microsoft.Web/sites/config                                                   | Ensure that App service enables HTTP logging                                                                      | Bicep | [AppServiceHttpLoggingEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AppServiceHttpLoggingEnabled.py)                                                             |
|  77 | CKV_AZURE_64  | resource  | Microsoft.StorageSync/storageSyncServices                                    | Ensure that Azure File Sync disables public network access                                                        | Bicep | [StorageSyncPublicAccessDisabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/StorageSyncPublicAccessDisabled.py)                                                       |
|  78 | CKV_AZURE_65  | resource  | Microsoft.Web/sites/config                                                   | Ensure that App service enables detailed error messages                                                           | Bicep | [AppServiceDetailedErrorMessagesEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AppServiceDetailedErrorMessagesEnabled.py)                                         |
|  79 | CKV_AZURE_66  | resource  | Microsoft.Web/sites/config                                                   | Ensure that App service enables failed request tracing                                                            | Bicep | [AppServiceEnableFailedRequest.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AppServiceEnableFailedRequest.py)                                                           |
|  80 | CKV_AZURE_67  | resource  | Microsoft.Web/sites                                                          | Ensure that 'HTTP Version' is the latest, if used to run the Function app                                         | Bicep | [FunctionAppHttpVersionLatest.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/FunctionAppHttpVersionLatest.py)                                                             |
|  81 | CKV_AZURE_67  | resource  | Microsoft.Web/sites/slots                                                    | Ensure that 'HTTP Version' is the latest, if used to run the Function app                                         | Bicep | [FunctionAppHttpVersionLatest.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/FunctionAppHttpVersionLatest.py)                                                             |
|  82 | CKV_AZURE_68  | resource  | Microsoft.DBforPostgreSQL/servers                                            | Ensure that PostgreSQL server disables public network access                                                      | Bicep | [PostgreSQLServerPublicAccessDisabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/PostgreSQLServerPublicAccessDisabled.py)                                             |
|  83 | CKV_AZURE_70  | resource  | Microsoft.Web/sites                                                          | Ensure that Function apps is only accessible over HTTPS                                                           | Bicep | [FunctionAppsAccessibleOverHttps.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/FunctionAppsAccessibleOverHttps.py)                                                       |
|  84 | CKV_AZURE_70  | resource  | Microsoft.Web/sites/config                                                   | Ensure that Function apps is only accessible over HTTPS                                                           | Bicep | [FunctionAppsAccessibleOverHttps.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/FunctionAppsAccessibleOverHttps.py)                                                       |
|  85 | CKV_AZURE_70  | resource  | Microsoft.Web/sites/slots                                                    | Ensure that Function apps is only accessible over HTTPS                                                           | Bicep | [FunctionAppsAccessibleOverHttps.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/FunctionAppsAccessibleOverHttps.py)                                                       |
|  86 | CKV_AZURE_71  | resource  | Microsoft.Web/sites                                                          | Ensure that Managed identity provider is enabled for web apps                                                     | Bicep | [AppServiceIdentityProviderEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AppServiceIdentityProviderEnabled.py)                                                   |
|  87 | CKV_AZURE_72  | resource  | Microsoft.Web/sites                                                          | Ensure that remote debugging is not enabled for app services                                                      | Bicep | [AppServiceRemoteDebuggingNotEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AppServiceRemoteDebuggingNotEnabled.py)                                               |
|  88 | CKV_AZURE_73  | resource  | Microsoft.Automation/automationAccounts/variables                            | Ensure that Automation account variables are encrypted                                                            | Bicep | [AutomationEncrypted.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AutomationEncrypted.py)                                                                               |
|  89 | CKV_AZURE_74  | resource  | Microsoft.Kusto/clusters                                                     | Ensure that Azure Data Explorer (Kusto) uses disk encryption                                                      | Bicep | [DataExplorerUsesDiskEncryption.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/DataExplorerUsesDiskEncryption.py)                                                         |
|  90 | CKV_AZURE_75  | resource  | Microsoft.Kusto/clusters                                                     | Ensure that Azure Data Explorer uses double encryption                                                            | Bicep | [AzureDataExplorerDoubleEncryptionEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AzureDataExplorerDoubleEncryptionEnabled.py)                                     |
|  91 | CKV_AZURE_76  | resource  | Microsoft.Batch/batchAccounts                                                | Ensure that Azure Batch account uses key vault to encrypt data                                                    | Bicep | [AzureBatchAccountUsesKeyVaultEncryption.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AzureBatchAccountUsesKeyVaultEncryption.py)                                       |
|  92 | CKV_AZURE_78  | resource  | Microsoft.Web/sites                                                          | Ensure FTP deployments are disabled                                                                               | Bicep | [AppServiceFTPSState.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AppServiceFTPSState.py)                                                                               |
|  93 | CKV_AZURE_79  | resource  | Microsoft.Security/pricings                                                  | Ensure that Azure Defender is set to On for SQL servers on machines                                               | Bicep | [AzureDefenderOnSqlServersVMS.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AzureDefenderOnSqlServersVMS.py)                                                             |
|  94 | CKV_AZURE_80  | resource  | Microsoft.Web/sites/config                                                   | Ensure that 'Net Framework' version is the latest, if used as a part of the web app                               | Bicep | [AppServiceDotnetFrameworkVersion.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AppServiceDotnetFrameworkVersion.py)                                                     |
|  95 | CKV_AZURE_81  | resource  | Microsoft.Web/sites                                                          | Ensure that 'PHP version' is the latest, if used to run the web app                                               | Bicep | [AppServicePHPVersion.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AppServicePHPVersion.py)                                                                             |
|  96 | CKV_AZURE_82  | resource  | Microsoft.Web/sites                                                          | Ensure that 'Python version' is the latest, if used to run the web app                                            | Bicep | [AppServicePythonVersion.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AppServicePythonVersion.py)                                                                       |
|  97 | CKV_AZURE_83  | resource  | Microsoft.Web/sites                                                          | Ensure that 'Java version' is the latest, if used to run the web app                                              | Bicep | [AppServiceJavaVersion.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AppServiceJavaVersion.py)                                                                           |
|  98 | CKV_AZURE_84  | resource  | Microsoft.Security/pricings                                                  | Ensure that Azure Defender is set to On for Storage                                                               | Bicep | [AzureDefenderOnStorage.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AzureDefenderOnStorage.py)                                                                         |
|  99 | CKV_AZURE_85  | resource  | Microsoft.Security/pricings                                                  | Ensure that Azure Defender is set to On for Kubernetes                                                            | Bicep | [AzureDefenderOnKubernetes.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AzureDefenderOnKubernetes.py)                                                                   |
| 100 | CKV_AZURE_87  | resource  | Microsoft.Security/pricings                                                  | Ensure that Azure Defender is set to On for Key Vault                                                             | Bicep | [AzureDefenderOnKeyVaults.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AzureDefenderOnKeyVaults.py)                                                                     |
| 101 | CKV_AZURE_88  | resource  | Microsoft.Web/sites/config                                                   | Ensure that app services use Azure Files                                                                          | Bicep | [AppServiceUsedAzureFiles.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AppServiceUsedAzureFiles.py)                                                                     |
| 102 | CKV_AZURE_89  | resource  | Microsoft.Cache/redis                                                        | Ensure that Azure Cache for Redis disables public network access                                                  | Bicep | [RedisCachePublicNetworkAccessEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/RedisCachePublicNetworkAccessEnabled.py)                                             |
| 103 | CKV_AZURE_92  | resource  | Microsoft.Compute/virtualMachines                                            | Ensure that Virtual Machines use managed disks                                                                    | Bicep | [VMStorageOsDisk.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/VMStorageOsDisk.py)                                                                                       |
| 104 | CKV_AZURE_93  | resource  | Microsoft.Compute/disks                                                      | Ensure that managed disks use a specific set of disk encryption sets for the customer-managed key encryption      | Bicep | [AzureManagedDiskEncryptionSet.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AzureManagedDiskEncryptionSet.py)                                                           |
| 105 | CKV_AZURE_94  | resource  | Microsoft.DBforMySQL/flexibleServers                                         | Ensure that My SQL server enables geo-redundant backups                                                           | Bicep | [MySQLGeoBackupEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/MySQLGeoBackupEnabled.py)                                                                           |
| 106 | CKV_AZURE_95  | resource  | Microsoft.Compute/virtualMachineScaleSets                                    | Ensure that automatic OS image patching is enabled for Virtual Machine Scale Sets                                 | Bicep | [VMScaleSetsAutoOSImagePatchingEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/VMScaleSetsAutoOSImagePatchingEnabled.py)                                           |
| 107 | CKV_AZURE_96  | resource  | Microsoft.DBforMySQL/flexibleServers                                         | Ensure that MySQL server enables infrastructure encryption                                                        | Bicep | [MySQLEncryptionEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/MySQLEncryptionEnabled.py)                                                                         |
| 108 | CKV_AZURE_97  | resource  | Microsoft.Compute/virtualMachineScaleSets                                    | Ensure that Virtual machine scale sets have encryption at host enabled                                            | Bicep | [VMEncryptionAtHostEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/VMEncryptionAtHostEnabled.py)                                                                   |
| 109 | CKV_AZURE_97  | resource  | Microsoft.Compute/virtualMachines                                            | Ensure that Virtual machine scale sets have encryption at host enabled                                            | Bicep | [VMEncryptionAtHostEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/VMEncryptionAtHostEnabled.py)                                                                   |
| 110 | CKV_AZURE_99  | resource  | Microsoft.DocumentDB/databaseAccounts                                        | Ensure Cosmos DB accounts have restricted access                                                                  | Bicep | [CosmosDBAccountsRestrictedAccess.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/CosmosDBAccountsRestrictedAccess.py)                                                     |
| 111 | CKV_AZURE_100 | resource  | Microsoft.DocumentDb/databaseAccounts                                        | Ensure that Cosmos DB accounts have customer-managed keys to encrypt data at rest                                 | Bicep | [CosmosDBHaveCMK.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/CosmosDBHaveCMK.py)                                                                                       |
| 112 | CKV_AZURE_101 | resource  | Microsoft.DocumentDB/databaseAccounts                                        | Ensure that Azure Cosmos DB disables public network access                                                        | Bicep | [CosmosDBDisablesPublicNetwork.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/CosmosDBDisablesPublicNetwork.py)                                                           |
| 113 | CKV_AZURE_102 | resource  | Microsoft.DBforPostgreSQL/servers                                            | Ensure that PostgreSQL server enables geo-redundant backups                                                       | Bicep | [PostgressSQLGeoBackupEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/PostgressSQLGeoBackupEnabled.py)                                                             |
| 114 | CKV_AZURE_103 | resource  | Microsoft.DataFactory/factories                                              | Ensure that Azure Data Factory uses Git repository for source control                                             | Bicep | [DataFactoryUsesGitRepository.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/DataFactoryUsesGitRepository.py)                                                             |
| 115 | CKV_AZURE_104 | resource  | Microsoft.DataFactory/factories                                              | Ensure that Azure Data factory public network access is disabled                                                  | Bicep | [DataFactoryNoPublicNetworkAccess.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/DataFactoryNoPublicNetworkAccess.py)                                                     |
| 116 | CKV_AZURE_105 | resource  | Microsoft.DataLakeStore/accounts                                             | Ensure that Data Lake Store accounts enables encryption                                                           | Bicep | [DataLakeStoreEncryption.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/DataLakeStoreEncryption.py)                                                                       |
| 117 | CKV_AZURE_107 | resource  | Microsoft.ApiManagement/service                                              | Ensure that API management services use virtual networks                                                          | Bicep | [APIServicesUseVirtualNetwork.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/APIServicesUseVirtualNetwork.py)                                                             |
| 118 | CKV_AZURE_109 | resource  | Microsoft.KeyVault/vaults                                                    | Ensure that key vault allows firewall rules settings                                                              | Bicep | [KeyVaultEnablesFirewallRulesSettings.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/KeyVaultEnablesFirewallRulesSettings.py)                                             |
| 119 | CKV_AZURE_110 | resource  | Microsoft.KeyVault/vaults                                                    | Ensure that key vault enables purge protection                                                                    | Bicep | [KeyVaultEnablesPurgeProtection.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/KeyVaultEnablesPurgeProtection.py)                                                         |
| 120 | CKV_AZURE_111 | resource  | Microsoft.KeyVault/vaults                                                    | Ensure that key vault enables soft delete                                                                         | Bicep | [KeyVaultEnablesSoftDelete.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/KeyVaultEnablesSoftDelete.py)                                                                   |
| 121 | CKV_AZURE_112 | resource  | Microsoft.KeyVault/vaults/keys                                               | Ensure that key vault key is backed by HSM                                                                        | Bicep | [KeyBackedByHSM.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/KeyBackedByHSM.py)                                                                                         |
| 122 | CKV_AZURE_113 | resource  | Microsoft.Sql/servers                                                        | Ensure that SQL server disables public network access                                                             | Bicep | [SQLServerHasPublicAccessDisabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/SQLServerHasPublicAccessDisabled.py)                                                     |
| 123 | CKV_AZURE_114 | resource  | Microsoft.KeyVault/vaults/secrets                                            | Ensure that key vault secrets have "content_type" set                                                             | Bicep | [SecretContentType.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/SecretContentType.py)                                                                                   |
| 124 | CKV_AZURE_121 | resource  | Microsoft.Network/frontDoors                                                 | Ensure that Azure Front Door enables WAF                                                                          | Bicep | [AzureFrontDoorEnablesWAF.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AzureFrontDoorEnablesWAF.py)                                                                     |
| 125 | CKV_AZURE_123 | resource  | Microsoft.Network/FrontDoorWebApplicationFirewallPolicies                    | Ensure that Azure Front Door uses WAF in "Detection" or "Prevention" modes                                        | Bicep | [FrontdoorUseWAFMode.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/FrontdoorUseWAFMode.py)                                                                               |
| 126 | CKV_AZURE_125 | resource  | Microsoft.ServiceFabric/clusters                                             | Ensures that Service Fabric use three levels of protection available                                              | Bicep | [AzureServiceFabricClusterProtectionLevel.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AzureServiceFabricClusterProtectionLevel.py)                                     |
| 127 | CKV_AZURE_129 | resource  | Microsoft.DBforMariaDB/servers                                               | Ensure that MariaDB server enables geo-redundant backups                                                          | Bicep | [MariaDBGeoBackupEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/MariaDBGeoBackupEnabled.py)                                                                       |
| 128 | CKV_AZURE_130 | resource  | Microsoft.DBforPostgreSQL/servers                                            | Ensure that PostgreSQL server enables infrastructure encryption                                                   | Bicep | [PostgreSQLEncryptionEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/PostgreSQLEncryptionEnabled.py)                                                               |
| 129 | CKV_AZURE_131 | parameter | string                                                                       | SecureString parameter should not have hardcoded default values                                                   | Bicep | [SecureStringParameterNoHardcodedValue.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/bicep/checks/param/azure/SecureStringParameterNoHardcodedValue.py)                                      |
| 130 | CKV_AZURE_132 | resource  | Microsoft.DocumentDB/databaseAccounts                                        | Ensure cosmosdb does not allow privileged escalation by restricting management plane changes                      | Bicep | [CosmosDBDisableAccessKeyWrite.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/CosmosDBDisableAccessKeyWrite.py)                                                           |
| 131 | CKV_AZURE_133 | resource  | Microsoft.Network/frontdoorWebApplicationFirewallPolicies                    | Ensure Front Door WAF prevents message lookup in Log4j2. See CVE-2021-44228 aka log4jshell                        | Bicep | [FrontDoorWAFACLCVE202144228.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/FrontDoorWAFACLCVE202144228.py)                                                               |
| 132 | CKV_AZURE_134 | resource  | Microsoft.CognitiveServices/accounts                                         | Ensure that Cognitive Services accounts disable public network access                                             | Bicep | [CognitiveServicesDisablesPublicNetwork.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/CognitiveServicesDisablesPublicNetwork.py)                                         |
| 133 | CKV_AZURE_135 | resource  | Microsoft.Network/ApplicationGatewayWebApplicationFirewallPolicies           | Ensure Application Gateway WAF prevents message lookup in Log4j2. See CVE-2021-44228 aka log4jshell               | Bicep | [AppGatewayWAFACLCVE202144228.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AppGatewayWAFACLCVE202144228.py)                                                             |
| 134 | CKV_AZURE_137 | resource  | Microsoft.ContainerRegistry/registries                                       | Ensure ACR admin account is disabled                                                                              | Bicep | [ACRAdminAccountDisabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/ACRAdminAccountDisabled.py)                                                                       |
| 135 | CKV_AZURE_138 | resource  | Microsoft.ContainerRegistry/registries                                       | Ensures that ACR disables anonymous pulling of images                                                             | Bicep | [ACRAnonymousPullDisabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/ACRAnonymousPullDisabled.py)                                                                     |
| 136 | CKV_AZURE_139 | resource  | Microsoft.ContainerRegistry/registries                                       | Ensure ACR set to disable public networking                                                                       | Bicep | [ACRPublicNetworkAccessDisabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/ACRPublicNetworkAccessDisabled.py)                                                         |
| 137 | CKV_AZURE_140 | resource  | Microsoft.DocumentDB/databaseAccounts                                        | Ensure that Local Authentication is disabled on CosmosDB                                                          | Bicep | [CosmosDBLocalAuthDisabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/CosmosDBLocalAuthDisabled.py)                                                                   |
| 138 | CKV_AZURE_141 | resource  | Microsoft.ContainerService/managedClusters                                   | Ensure AKS local admin account is disabled                                                                        | Bicep | [AKSLocalAdminDisabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AKSLocalAdminDisabled.py)                                                                           |
| 139 | CKV_AZURE_145 | resource  | Microsoft.Web/sites                                                          | Ensure Function app is using the latest version of TLS encryption                                                 | Bicep | [FunctionAppMinTLSVersion.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/FunctionAppMinTLSVersion.py)                                                                     |
| 140 | CKV_AZURE_145 | resource  | Microsoft.Web/sites/slots                                                    | Ensure Function app is using the latest version of TLS encryption                                                 | Bicep | [FunctionAppMinTLSVersion.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/FunctionAppMinTLSVersion.py)                                                                     |
| 141 | CKV_AZURE_149 | resource  | Microsoft.Compute/virtualMachineScaleSets                                    | Ensure that Virtual machine does not enable password authentication                                               | Bicep | [VMDisablePasswordAuthentication.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/VMDisablePasswordAuthentication.py)                                                       |
| 142 | CKV_AZURE_149 | resource  | Microsoft.Compute/virtualMachines                                            | Ensure that Virtual machine does not enable password authentication                                               | Bicep | [VMDisablePasswordAuthentication.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/VMDisablePasswordAuthentication.py)                                                       |
| 143 | CKV_AZURE_151 | resource  | Microsoft.Compute/virtualMachines                                            | Ensure Windows VM enables encryption                                                                              | Bicep | [WinVMEncryptionAtHost.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/WinVMEncryptionAtHost.py)                                                                           |
| 144 | CKV_AZURE_153 | resource  | Microsoft.Web/sites                                                          | Ensure web app redirects all HTTP traffic to HTTPS in Azure App Service Slot                                      | Bicep | [AppServiceSlotHTTPSOnly.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AppServiceSlotHTTPSOnly.py)                                                                       |
| 145 | CKV_AZURE_153 | resource  | Microsoft.Web/sites/slots                                                    | Ensure web app redirects all HTTP traffic to HTTPS in Azure App Service Slot                                      | Bicep | [AppServiceSlotHTTPSOnly.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AppServiceSlotHTTPSOnly.py)                                                                       |
| 146 | CKV_AZURE_155 | resource  | Microsoft.Web/sites                                                          | Ensure debugging is disabled for the App service slot                                                             | Bicep | [AppServiceSlotDebugDisabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AppServiceSlotDebugDisabled.py)                                                               |
| 147 | CKV_AZURE_155 | resource  | Microsoft.Web/sites/slots                                                    | Ensure debugging is disabled for the App service slot                                                             | Bicep | [AppServiceSlotDebugDisabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AppServiceSlotDebugDisabled.py)                                                               |
| 148 | CKV_AZURE_157 | resource  | Microsoft.Synapse/workspaces                                                 | Ensure that Synapse workspace has data_exfiltration_protection_enabled                                            | Bicep | [SynapseWorkspaceEnablesDataExfilProtection.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/SynapseWorkspaceEnablesDataExfilProtection.py)                                 |
| 149 | CKV_AZURE_158 | resource  | Microsoft.Databricks/workspaces                                              | Ensure Databricks Workspace data plane to control plane communication happens over private link                   | Bicep | [DatabricksWorkspaceIsNotPublic.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/DatabricksWorkspaceIsNotPublic.py)                                                         |
| 150 | CKV_AZURE_160 | resource  | Microsoft.Network/networkSecurityGroups                                      | Ensure that HTTP (port 80) access is restricted from the internet                                                 | Bicep | [NSGRuleHTTPAccessRestricted.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/NSGRuleHTTPAccessRestricted.py)                                                               |
| 151 | CKV_AZURE_160 | resource  | Microsoft.Network/networkSecurityGroups/securityRules                        | Ensure that HTTP (port 80) access is restricted from the internet                                                 | Bicep | [NSGRuleHTTPAccessRestricted.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/NSGRuleHTTPAccessRestricted.py)                                                               |
| 152 | CKV_AZURE_163 | resource  | Microsoft.ContainerRegistry/registries                                       | Enable vulnerability scanning for container images.                                                               | Bicep | [ACRContainerScanEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/ACRContainerScanEnabled.py)                                                                       |
| 153 | CKV_AZURE_166 | resource  | Microsoft.ContainerRegistry/registries                                       | Ensure container image quarantine, scan, and mark images verified                                                 | Bicep | [ACREnableImageQuarantine.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/ACREnableImageQuarantine.py)                                                                     |
| 154 | CKV_AZURE_168 | resource  | Microsoft.ContainerService/managedClusters                                   | Ensure Azure Kubernetes Cluster (AKS) nodes should use a minimum number of 50 pods.                               | Bicep | [AKSMaxPodsMinimum.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AKSMaxPodsMinimum.py)                                                                                   |
| 155 | CKV_AZURE_168 | resource  | Microsoft.ContainerService/managedClusters/agentPools                        | Ensure Azure Kubernetes Cluster (AKS) nodes should use a minimum number of 50 pods.                               | Bicep | [AKSMaxPodsMinimum.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AKSMaxPodsMinimum.py)                                                                                   |
| 156 | CKV_AZURE_169 | resource  | Microsoft.ContainerService/managedClusters                                   | Ensure Azure Kubernetes Cluster (AKS) nodes use scale sets                                                        | Bicep | [AKSPoolTypeIsScaleSet.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AKSPoolTypeIsScaleSet.py)                                                                           |
| 157 | CKV_AZURE_171 | resource  | Microsoft.ContainerService/managedClusters                                   | Ensure AKS cluster upgrade channel is chosen                                                                      | Bicep | [AKSUpgradeChannel.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AKSUpgradeChannel.py)                                                                                   |
| 158 | CKV_AZURE_172 | resource  | Microsoft.ContainerService/managedClusters                                   | Ensure autorotation of Secrets Store CSI Driver secrets for AKS clusters                                          | Bicep | [AkSSecretStoreRotation.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AkSSecretStoreRotation.py)                                                                         |
| 159 | CKV_AZURE_173 | resource  | Microsoft.ApiManagement/service                                              | Ensure API management uses at least TLS 1.2                                                                       | Bicep | [APIManagementMinTLS12.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/APIManagementMinTLS12.py)                                                                           |
| 160 | CKV_AZURE_174 | resource  | Microsoft.ApiManagement/service                                              | Ensure API management public access is disabled                                                                   | Bicep | [APIManagementPublicAccess.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/APIManagementPublicAccess.py)                                                                   |
| 161 | CKV_AZURE_175 | resource  | Microsoft.SignalRService/webPubSub                                           | Ensure Web PubSub uses a SKU with an SLA                                                                          | Bicep | [PubsubSKUSLA.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/PubsubSKUSLA.py)                                                                                             |
| 162 | CKV_AZURE_176 | resource  | Microsoft.SignalRService/webPubSub                                           | Ensure Web PubSub uses managed identities to access Azure resources                                               | Bicep | [PubsubSpecifyIdentity.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/PubsubSpecifyIdentity.py)                                                                           |
| 163 | CKV_AZURE_177 | resource  | Microsoft.Compute/virtualMachineScaleSets                                    | Ensure Windows VM enables automatic updates                                                                       | Bicep | [WinVMAutomaticUpdates.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/WinVMAutomaticUpdates.py)                                                                           |
| 164 | CKV_AZURE_177 | resource  | Microsoft.Compute/virtualMachines                                            | Ensure Windows VM enables automatic updates                                                                       | Bicep | [WinVMAutomaticUpdates.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/WinVMAutomaticUpdates.py)                                                                           |
| 165 | CKV_AZURE_178 | resource  | Microsoft.Compute/virtualMachineScaleSets                                    | Ensure linux VM enables SSH with keys for secure communication                                                    | Bicep | [LinuxVMUsesSSH.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/LinuxVMUsesSSH.py)                                                                                         |
| 166 | CKV_AZURE_178 | resource  | Microsoft.Compute/virtualMachines                                            | Ensure linux VM enables SSH with keys for secure communication                                                    | Bicep | [LinuxVMUsesSSH.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/LinuxVMUsesSSH.py)                                                                                         |
| 167 | CKV_AZURE_182 | resource  | Microsoft.Network/networkInterfaces                                          | Ensure that VNET has at least 2 connected DNS Endpoints                                                           | Bicep | [VnetSingleDNSServer.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/VnetSingleDNSServer.py)                                                                               |
| 168 | CKV_AZURE_182 | resource  | Microsoft.Network/virtualNetworks                                            | Ensure that VNET has at least 2 connected DNS Endpoints                                                           | Bicep | [VnetSingleDNSServer.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/VnetSingleDNSServer.py)                                                                               |
| 169 | CKV_AZURE_183 | resource  | Microsoft.Network/virtualNetworks                                            | Ensure that VNET uses local DNS addresses                                                                         | Bicep | [VnetLocalDNS.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/VnetLocalDNS.py)                                                                                             |
| 170 | CKV_AZURE_189 | resource  | Microsoft.KeyVault/vaults                                                    | Ensure that Azure Key Vault disables public network access                                                        | Bicep | [KeyVaultDisablesPublicNetworkAccess.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/KeyVaultDisablesPublicNetworkAccess.py)                                               |
| 171 | CKV_AZURE_191 | resource  | Microsoft.EventGrid/topics                                                   | Ensure that Managed identity provider is enabled for Azure Event Grid Topic                                       | Bicep | [EventgridTopicIdentityProviderEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/EventgridTopicIdentityProviderEnabled.py)                                           |
| 172 | CKV_AZURE_192 | resource  | Microsoft.EventGrid/topics                                                   | Ensure that Azure Event Grid Topic local Authentication is disabled                                               | Bicep | [EventgridTopicLocalAuthentication.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/EventgridTopicLocalAuthentication.py)                                                   |
| 173 | CKV_AZURE_193 | resource  | Microsoft.EventGrid/topics                                                   | Ensure public network access is disabled for Azure Event Grid Topic                                               | Bicep | [EventgridTopicNetworkAccess.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/EventgridTopicNetworkAccess.py)                                                               |
| 174 | CKV_AZURE_206 | resource  | Microsoft.Storage/storageAccounts                                            | Ensure that Storage Accounts use replication                                                                      | Bicep | [StorageAccountsUseReplication.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/StorageAccountsUseReplication.py)                                                           |
| 175 | CKV_AZURE_208 | resource  | Microsoft.Search/searchServices                                              | Ensure that Azure Cognitive Search maintains SLA for index updates                                                | Bicep | [AzureSearchSLAIndex.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AzureSearchSLAIndex.py)                                                                               |
| 176 | CKV_AZURE_209 | resource  | Microsoft.Search/searchServices                                              | Ensure that Azure Cognitive Search maintains SLA for search index queries                                         | Bicep | [AzureSearchSLAQueryUpdates.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AzureSearchSLAQueryUpdates.py)                                                                 |
| 177 | CKV_AZURE_212 | resource  | Microsoft.Web/sites                                                          | Ensure App Service has a minimum number of instances for failover                                                 | Bicep | [AppServiceInstanceMinimum.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AppServiceInstanceMinimum.py)                                                                   |
| 178 | CKV_AZURE_212 | resource  | Microsoft.Web/sites/slots                                                    | Ensure App Service has a minimum number of instances for failover                                                 | Bicep | [AppServiceInstanceMinimum.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AppServiceInstanceMinimum.py)                                                                   |
| 179 | CKV_AZURE_213 | resource  | Microsoft.Web/sites                                                          | Ensure that App Service configures health check                                                                   | Bicep | [AppServiceSetHealthCheck.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AppServiceSetHealthCheck.py)                                                                     |
| 180 | CKV_AZURE_213 | resource  | Microsoft.Web/sites/slots                                                    | Ensure that App Service configures health check                                                                   | Bicep | [AppServiceSetHealthCheck.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AppServiceSetHealthCheck.py)                                                                     |
| 181 | CKV_AZURE_216 | resource  | Microsoft.Network/azureFirewalls                                             | Ensure DenyIntelMode is set to Deny for Azure Firewalls                                                           | Bicep | [AzureFirewallDenyThreatIntelMode.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AzureFirewallDenyThreatIntelMode.py)                                                     |
| 182 | CKV_AZURE_218 | resource  | Microsoft.Network/applicationGateways                                        | Ensure Application Gateway defines secure protocols for in transit communication                                  | Bicep | [AppGWDefinesSecureProtocols.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AppGWDefinesSecureProtocols.py)                                                               |
| 183 | CKV_AZURE_222 | resource  | Microsoft.Web/sites                                                          | Ensure that Azure Web App public network access is disabled                                                       | Bicep | [AppServicePublicAccessDisabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AppServicePublicAccessDisabled.py)                                                         |
| 184 | CKV_AZURE_222 | resource  | Microsoft.Web/sites/config                                                   | Ensure that Azure Web App public network access is disabled                                                       | Bicep | [AppServicePublicAccessDisabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AppServicePublicAccessDisabled.py)                                                         |
| 185 | CKV_AZURE_222 | resource  | Microsoft.Web/sites/slots                                                    | Ensure that Azure Web App public network access is disabled                                                       | Bicep | [AppServicePublicAccessDisabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AppServicePublicAccessDisabled.py)                                                         |
| 186 | CKV_AZURE_223 | resource  | Microsoft.EventHub/namespaces                                                | Ensure Event Hub Namespace uses at least TLS 1.2                                                                  | Bicep | [EventHubNamespaceMinTLS12.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/EventHubNamespaceMinTLS12.py)                                                                   |
| 187 | CKV_AZURE_225 | resource  | Microsoft.Web/serverfarms                                                    | Ensure the App Service Plan is zone redundant                                                                     | Bicep | [AppServicePlanZoneRedundant.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AppServicePlanZoneRedundant.py)                                                               |
| 188 | CKV_AZURE_226 | resource  | Microsoft.ContainerService/managedClusters                                   | Ensure ephemeral disks are used for OS disks                                                                      | Bicep | [AKSEphemeralOSDisks.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AKSEphemeralOSDisks.py)                                                                               |
| 189 | CKV_AZURE_227 | resource  | Microsoft.ContainerService/managedClusters                                   | Ensure that the AKS cluster encrypt temp disks, caches, and data flows between Compute and Storage resources      | Bicep | [AKSEncryptionAtHostEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AKSEncryptionAtHostEnabled.py)                                                                 |
| 190 | CKV_AZURE_227 | resource  | Microsoft.ContainerService/managedClusters/agentPools                        | Ensure that the AKS cluster encrypt temp disks, caches, and data flows between Compute and Storage resources      | Bicep | [AKSEncryptionAtHostEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AKSEncryptionAtHostEnabled.py)                                                                 |
| 191 | CKV_AZURE_229 | resource  | Microsoft.Sql/servers/databases                                              | Ensure the Azure SQL Database Namespace is zone redundant                                                         | Bicep | [SQLDatabaseZoneRedundant.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/SQLDatabaseZoneRedundant.py)                                                                     |
| 192 | CKV_AZURE_233 | resource  | Microsoft.ContainerRegistry/registries                                       | Ensure Azure Container Registry (ACR) is zone redundant                                                           | Bicep | [ACREnableZoneRedundancy.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/ACREnableZoneRedundancy.py)                                                                       |
| 193 | CKV_AZURE_233 | resource  | Microsoft.ContainerRegistry/registries/replications                          | Ensure Azure Container Registry (ACR) is zone redundant                                                           | Bicep | [ACREnableZoneRedundancy.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/ACREnableZoneRedundancy.py)                                                                       |
| 194 | CKV_AZURE_236 | resource  | Microsoft.CognitiveServices/accounts                                         | Ensure that Cognitive Services accounts disable local authentication                                              | Bicep | [CognitiveServicesEnableLocalAuth.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/CognitiveServicesEnableLocalAuth.py)                                                     |
| 195 | CKV_AZURE_238 | resource  | Microsoft.CognitiveServices/accounts                                         | Ensure that all Azure Cognitive Services accounts are configured with a managed identity                          | Bicep | [CognitiveServicesConfigureIdentity.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/CognitiveServicesConfigureIdentity.py)                                                 |
| 196 | CKV_AZURE_239 | resource  | Microsoft.Synapse/workspaces                                                 | Ensure Azure Synapse Workspace administrator login password is not exposed                                        | Bicep | [SynapseWorkspaceAdministratorLoginPasswordHidden.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/SynapseWorkspaceAdministratorLoginPasswordHidden.py)                     |
| 197 | CKV_AZURE_240 | resource  | Microsoft.Synapse/workspaces                                                 | Ensure Azure Synapse Workspace is encrypted with a CMK                                                            | Bicep | [SynapseWorkspaceCMKEncryption.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/SynapseWorkspaceCMKEncryption.py)                                                           |
| 198 | CKV_AZURE_242 | resource  | Microsoft.Synapse/workspaces/bigDataPools                                    | Ensure isolated compute is enabled for Synapse Spark pools                                                        | Bicep | [AzureSparkPoolIsolatedComputeEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AzureSparkPoolIsolatedComputeEnabled.py)                                             |
| 199 | CKV_AZURE_243 | resource  | Microsoft.MachineLearningServices/workspaces                                 | Ensure Azure Machine learning workspace is configured with private endpoint                                       | Bicep | [AzureMLWorkspacePrivateEndpoint.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AzureMLWorkspacePrivateEndpoint.py)                                                       |
| 200 | CKV_AZURE_248 | resource  | Microsoft.Batch/batchAccounts                                                | Ensure that if Azure Batch account public network access in case 'enabled' then its account access must be 'deny' | Bicep | [AzureBatchAccountEndpointAccessDefaultAction.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AzureBatchAccountEndpointAccessDefaultAction.py)                             |
| 201 | CKV2_AZURE_19 | resource  | Microsoft.Synapse/workspaces                                                 | Ensure that Azure Synapse workspaces have no IP firewall rules attached                                           | Bicep | [AzureSynapseWorkspacesHaveNoIPFirewallRulesAttached.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AzureSynapseWorkspacesHaveNoIPFirewallRulesAttached.py)               |
| 202 | CKV2_AZURE_27 | resource  | Microsoft.Sql/servers                                                        | Ensure Azure AD authentication is enabled for Azure SQL (MSSQL)                                                   | Bicep | [SQLServerUsesADAuth.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/SQLServerUsesADAuth.py)                                                                               |
| 203 | CKV2_AZURE_46 | resource  | Microsoft.Synapse/workspaces/vulnerabilityAssessments                        | Ensure that Azure Synapse Workspace vulnerability assessment is enabled                                           | Bicep | [AzureSynapseWorkspaceVAisEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/AzureSynapseWorkspaceVAisEnabled.py)                                                     |
| 204 | CKV2_AZURE_48 | resource  | Microsoft.Databricks/workspaces                                              | Ensure that Databricks Workspaces enables customer-managed key for root DBFS encryption                           | Bicep | [DatabricksWorkspaceDBFSRootEncryptedWithCustomerManagedKey.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/arm/checks/resource/DatabricksWorkspaceDBFSRootEncryptedWithCustomerManagedKey.py) |


---


